/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.utils;

import filenet.vw.api.VWException;
import filenet.vw.api.VWSession;
import filenet.vw.api.VWUserInfo;
import filenet.vw.base.VWDebug;
import filenet.vw.base.VWString;
import filenet.vw.idm.toolkit.IVWIDMFactory;
import filenet.vw.idm.toolkit.VWIDMBaseFactory;
import filenet.vw.toolkit.utils.VWCommandLineArgs;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.VWWebAppComboBox;
import filenet.vw.toolkit.utils.dialog.VWLogonDialog;
import filenet.vw.toolkit.utils.dialog.VWMessageDialog;
import filenet.vw.toolkit.utils.dialog.VWModalDialog;
import filenet.vw.toolkit.utils.resources.VWResource;
import java.applet.Applet;
import java.awt.Container;
import java.awt.Frame;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JApplet;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JRootPane;

public class VWSessionInfo
implements Cloneable {
    public static final int TRACKER_MODE_BASED_ON_WOB = 0;
    public static final int TRACKER_MODE_READ_ONLY = 1;
    public static final int TRACKER_MODE_FULL = 2;
    private static final String PROP_BROWSER_LOCALE = "prop_browser_locale";
    private static final String PROP_CAN_SAVE_TO_DMS = "prop_can_save_to_DMS";
    private static final String PROP_DISPLAY_P8_FUNCTIONALITY = "prop_display_p8_functionality";
    private static final String PROP_DISPLAY_PDEX_FUNCTIONALITY = "prop_display_pdex_functionality";
    private static final String PROP_DISPLAY_ADMIN_FUNCTIONALITY = "prop_display_administration_functionality";
    private static final String PROP_DISPLAY_CONFIG_FUNCTIONALITY = "prop_display_configuration_functionality";
    private static final String PROP_DISPLAY_SIM_DESIGNER_FUNCTIONALITY = "prop_display_sim_designer_functionality";
    private static final String PROP_DISPLAY_SIM_CONSOLE_FUNCTIONALITY = "prop_display_sim_console_functionality";
    private static final String PROP_IS_CUSTOM_WEB_APP = "prop_is_custom_web_app";
    private static final String PROP_IS_OPEN_CLIENT_APP = "prop_is_open_client_app";
    private static final String PROP_IS_WEB_WORKFLO_APP = "prop_is_web_workflo_app";
    private static final String PROP_IS_WORKPLACE_APP = "prop_is_workplace_app";
    private static final String PROP_SHOW_PARTICIPANTS = "prop_show_participants";
    private static final String DEVELOPMENT_MODE = "developmentMode";
    private static final String ACCESS_ROLE_PDEX = "P8BPMProcessDesignerEx";
    private static final String ACCESS_ROLE_ADMINISTRATOR = "PWAdministrator";
    private static final String ACCESS_ROLE_AE_ADMINISTRATOR = "AEAdmin";
    private static final String ACCESS_ROLE_CONFIGURATION = "PWConfiguration";
    private static final String ACCESS_ROLE_SIM_DESIGNER = "PSDesigner";
    private static final String ACCESS_ROLE_SIM_CONSOLE = "PSConsole";
    private VWLogonDialog m_logonDialog = null;
    private JApplet m_parentApplet = null;
    private Container m_parentContainer = null;
    private Frame m_parentFrame = null;
    private VWSession m_vwSession = null;
    private Properties m_properties = null;
    private int m_trackerMode = 0;
    private int m_nWidth = 800;
    private int m_nHeight = 600;
    private String m_selectedRouterPath = null;
    private Hashtable m_hiddenProperties = null;
    private int m_privilegesFlags = -1;

    public VWSessionInfo(Container parentContainer, JApplet parentApplet, VWSession vwSession) {
        try {
            this.m_parentContainer = parentContainer;
            this.m_parentApplet = parentApplet;
            this.m_vwSession = vwSession;
            this.m_properties = new Properties();
            if (this.m_properties != null && parentApplet != null) {
                String jarArchive;
                String inputFile = parentApplet.getParameter("inputfile");
                if (inputFile != null) {
                    try {
                        VWCommandLineArgs args = new VWCommandLineArgs(inputFile, false);
                        this.initializeUsingArgs(args);
                    }
                    catch (Exception ex) {
                        VWDebug.logException(ex);
                    }
                } else {
                    this.setProperty("webApp", parentApplet.getParameter("webApp"));
                    this.setProperty("idmPort", parentApplet.getParameter("idmPort"));
                    this.setProperty("routerHostName", parentApplet.getParameter("routerHostName"));
                    this.setProperty("routerNames", parentApplet.getParameter("routerNames"));
                    this.setProperty("routerPorts", parentApplet.getParameter("routerPorts"));
                    this.setProperty("routerServiceNames", parentApplet.getParameter("routerServiceNames"));
                    this.setProperty("routerIsolatedRegions", parentApplet.getParameter("routerIsolatedRegions"));
                    this.setProperty("displayPage", parentApplet.getParameter("displayPage"));
                    this.setProperty("baseURL", parentApplet.getParameter("baseURL"));
                    this.setProperty("browserLocale", parentApplet.getParameter("browserLocale"));
                    this.setProperty("AEProxyBaseURL", parentApplet.getParameter("AEProxyBaseURL"));
                    this.setDefaultLocale();
                    this.setProperty(DEVELOPMENT_MODE, parentApplet.getParameter(DEVELOPMENT_MODE));
                    String hostName = this.getHostName(parentApplet);
                    if (hostName != null) {
                        this.setProperty("hostName", hostName);
                    } else {
                        hostName = parentApplet.getParameter("hostName");
                        if (hostName != null) {
                            this.setProperty("hostName", hostName);
                        } else {
                            System.out.println("The host name is null!");
                        }
                    }
                    this.setProperty("library", parentApplet.getParameter("library"));
                    this.setProperty("docType", parentApplet.getParameter("docType"));
                    this.setProperty("docId", parentApplet.getParameter("docId"));
                    this.setProperty("linkType", parentApplet.getParameter("linkType"));
                    this.setProperty("participants", parentApplet.getParameter("participants"));
                    this.setProperty("step_palettes", parentApplet.getParameter("step_palettes"));
                    this.setProperty("workflowDefinitionDocID", parentApplet.getParameter("workflowDefinitionDocID"));
                    this.setProperty("subject", parentApplet.getParameter("subject"));
                    this.setProperty("mainAttachmentDocID", parentApplet.getParameter("mainAttachmentDocID"));
                    this.setProperty("propertyMap", parentApplet.getParameter("propertyMap"));
                    this.setProperty("queueName", parentApplet.getParameter("queueName"));
                    this.setProperty("wobNumber", parentApplet.getParameter("wobNumber"));
                    this.setProperty("defaultPrefsObjects", parentApplet.getParameter("defaultPrefsObjects"));
                    this.setProperty("documentServerURL", parentApplet.getParameter("documentServerURL"));
                    this.setProperty("filteredObjectStoreList", parentApplet.getParameter("filteredObjectStoreList"));
                    this.setProperty("keepAlive", parentApplet.getParameter("keepAlive"));
                    this.setProperty("keepAliveClassName", parentApplet.getParameter("keepAliveClassName"));
                    this.setProperty("keepAliveURL", parentApplet.getParameter("keepAliveURL"));
                    this.setProperty("p8bpm.listener.url", parentApplet.getParameter("p8bpm.listener.url"));
                    this.setProperty("Session", parentApplet.getParameter("Session"));
                    this.setProperty("sessionId", parentApplet.getParameter("sessionId"));
                    this.setProperty("sessionTunnelURL", parentApplet.getParameter("sessionTunnelURL"));
                    this.setProperty("sitePreferences", parentApplet.getParameter("sitePreferences"));
                    this.setProperty("systemRoles", parentApplet.getParameter("systemRoles"));
                    this.setProperty("token", parentApplet.getParameter("token"));
                    this.setProperty("userPreferences", parentApplet.getParameter("userPreferences"));
                    this.setProperty("version", parentApplet.getParameter("version"));
                    this.setProperty("vwSoapServlet", parentApplet.getParameter("vwSoapServlet"));
                    this.setProperty("defaultRouter", parentApplet.getParameter("defaultRouter"));
                    this.setProperty("webServerDownloadURL", parentApplet.getParameter("webServerDownloadURL"));
                    this.setProperty("webRouters", parentApplet.getParameter("webRouters"));
                    this.setProperty("webServerUploadURL", parentApplet.getParameter("webServerUploadURL"));
                    this.setProperty("webServerURL", parentApplet.getParameter("webServerURL"));
                    this.setProperty("caseTypeSymbolicName", parentApplet.getParameter("caseTypeSymbolicName"));
                    this.setProperty("solutionVsId", parentApplet.getParameter("solutionVsId"));
                    this.setProperty("workflowName", parentApplet.getParameter("workflowName"));
                }
                URL codeBaseURL = parentApplet.getCodeBase();
                if (codeBaseURL != null) {
                    this.setProperty("codebase", codeBaseURL.toString());
                }
                if ((jarArchive = parentApplet.getParameter("cache_archive")) != null && jarArchive.length() > 0) {
                    this.setProperty("jarArchive", jarArchive);
                } else {
                    jarArchive = parentApplet.getParameter("archive");
                    if (jarArchive != null && jarArchive.length() > 0) {
                        this.setProperty("jarArchive", jarArchive);
                    }
                }
                try {
                    String webApp = parentApplet.getParameter("webApp");
                    VWIDMBaseFactory.instance(webApp, parentApplet);
                }
                catch (Exception ex) {
                    VWDebug.logException(ex);
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public VWSessionInfo(Container parentContainer, JApplet parentApplet) {
        this(parentContainer, parentApplet, (VWSession)null);
    }

    public VWSessionInfo(Container parentContainer, JApplet parentApplet, VWCommandLineArgs args) {
        this(parentContainer, parentApplet, (VWSession)null);
        this.initializeUsingArgs(args);
    }

    public VWSessionInfo(Container parentContainer, VWCommandLineArgs args, VWSession vwSession) {
        this(parentContainer, (JApplet)null, vwSession);
        this.initializeUsingArgs(args);
    }

    public VWSessionInfo(VWSessionInfo vwSessionInfo) {
        this(vwSessionInfo.getParentContainer(), vwSessionInfo.getParentApplet(), (VWSession)null);
        this.m_properties = (Properties)vwSessionInfo.m_properties.clone();
        this.m_trackerMode = vwSessionInfo.m_trackerMode;
        this.m_nWidth = vwSessionInfo.m_nWidth;
        this.m_nHeight = vwSessionInfo.m_nHeight;
        if (vwSessionInfo.m_hiddenProperties != null) {
            this.m_hiddenProperties = (Hashtable)vwSessionInfo.m_hiddenProperties.clone();
        }
    }

    public Locale getBrowserLocale() {
        Object value = this.getHiddenProperty(PROP_BROWSER_LOCALE);
        if (value != null && value instanceof Locale) {
            return (Locale)value;
        }
        Locale browserLocale = null;
        try {
            String[] pieces;
            String localeStr;
            browserLocale = VWString.getResourceBundleLocale();
            if (browserLocale == null && (localeStr = this.getProperty("browserLocale")) != null && localeStr.length() > 0 && (pieces = this.parseString(localeStr)) != null) {
                String[] values = new String[2];
                for (int i = 0; i < pieces.length; ++i) {
                    int nIndex = pieces[i].indexOf("=");
                    if (nIndex == -1 || nIndex + 1 >= pieces[i].length()) continue;
                    values[i] = pieces[i].substring(nIndex + 1, pieces[i].length()).trim();
                }
                if (values[0] != null && values[0].length() > 0) {
                    browserLocale = values[1] != null && values[1].length() > 0 ? new Locale(values[0], values[1]) : new Locale(values[0]);
                    Locale.setDefault(browserLocale);
                    VWString.getStringFromKey("test");
                    browserLocale = VWString.getResourceBundleLocale();
                    Locale.setDefault(browserLocale);
                }
            }
            if (browserLocale != null) {
                this.setHiddenProperty(PROP_BROWSER_LOCALE, browserLocale);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return browserLocale;
    }

    public boolean getCanSaveToDMS() {
        boolean bCanSaveToDMS = false;
        try {
            Object value = this.getHiddenProperty(PROP_CAN_SAVE_TO_DMS);
            if (value != null && value instanceof Boolean) {
                return (Boolean)value;
            }
            if (VWIDMBaseFactory.instance() != null) {
                bCanSaveToDMS = true;
                if (this.isCustomWebApp()) {
                    Object bCanAdd;
                    bCanSaveToDMS = false;
                    IVWIDMFactory idmFactory = VWIDMBaseFactory.instance();
                    if (idmFactory != null && idmFactory.getProperties() != null && (bCanAdd = idmFactory.getProperties().getProperty("canSaveToDMS")) != null && bCanAdd instanceof Boolean) {
                        bCanSaveToDMS = (Boolean)bCanAdd;
                    }
                }
                this.setHiddenProperty(PROP_CAN_SAVE_TO_DMS, bCanSaveToDMS);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return bCanSaveToDMS;
    }

    public boolean getDisplayFullBPMFunctionality() {
        return true;
    }

    public boolean getDisplayP8BPMFunctionality() {
        boolean bDisplayP8Functionality;
        Object value = this.getHiddenProperty(PROP_DISPLAY_P8_FUNCTIONALITY);
        if (value != null && value instanceof Boolean) {
            return (Boolean)value;
        }
        boolean bl = bDisplayP8Functionality = !this.isIMSuiteWebApp();
        if (!bDisplayP8Functionality) {
            bDisplayP8Functionality = this.isDevelopmentModeEnabled();
        }
        this.setHiddenProperty(PROP_DISPLAY_P8_FUNCTIONALITY, bDisplayP8Functionality);
        return bDisplayP8Functionality;
    }

    public boolean getDisplayPDExFunctionality() {
        Object value = this.getHiddenProperty(PROP_DISPLAY_PDEX_FUNCTIONALITY);
        if (value != null && value instanceof Boolean) {
            return (Boolean)value;
        }
        boolean bDisplayPDExFunctionality = this.isMemberOfAccessRole(ACCESS_ROLE_PDEX);
        if (!bDisplayPDExFunctionality) {
            bDisplayPDExFunctionality = this.isDevelopmentModeEnabled();
        }
        this.setHiddenProperty(PROP_DISPLAY_PDEX_FUNCTIONALITY, bDisplayPDExFunctionality);
        return bDisplayPDExFunctionality;
    }

    public boolean getDisplaySimulationDesignerFunctionality() {
        Object value = this.getHiddenProperty(PROP_DISPLAY_SIM_DESIGNER_FUNCTIONALITY);
        if (value != null && value instanceof Boolean) {
            return (Boolean)value;
        }
        boolean bDisplaySimulationFunctionality = this.isMemberOfAccessRole(ACCESS_ROLE_SIM_DESIGNER);
        if (!bDisplaySimulationFunctionality) {
            bDisplaySimulationFunctionality = this.isMemberOfAccessRole(ACCESS_ROLE_AE_ADMINISTRATOR);
        }
        if (!bDisplaySimulationFunctionality) {
            bDisplaySimulationFunctionality = this.isDevelopmentModeEnabled();
        }
        this.setHiddenProperty(PROP_DISPLAY_SIM_DESIGNER_FUNCTIONALITY, bDisplaySimulationFunctionality);
        return bDisplaySimulationFunctionality;
    }

    public boolean getDisplaySimulationConsoleFunctionality() {
        Object value = this.getHiddenProperty(PROP_DISPLAY_SIM_CONSOLE_FUNCTIONALITY);
        if (value != null && value instanceof Boolean) {
            return (Boolean)value;
        }
        boolean bDisplaySimulationFunctionality = this.isMemberOfAccessRole(ACCESS_ROLE_SIM_CONSOLE);
        if (!bDisplaySimulationFunctionality) {
            bDisplaySimulationFunctionality = this.isMemberOfAccessRole(ACCESS_ROLE_AE_ADMINISTRATOR);
        }
        if (!bDisplaySimulationFunctionality) {
            bDisplaySimulationFunctionality = this.isDevelopmentModeEnabled();
        }
        this.setHiddenProperty(PROP_DISPLAY_SIM_CONSOLE_FUNCTIONALITY, bDisplaySimulationFunctionality);
        return bDisplaySimulationFunctionality;
    }

    public boolean getDisplayAdministrationFunctionality() {
        Object value = this.getHiddenProperty(PROP_DISPLAY_ADMIN_FUNCTIONALITY);
        if (value != null && value instanceof Boolean) {
            return (Boolean)value;
        }
        boolean bDisplayAdministrationFunctionality = this.isIMSuiteWebApp();
        if (!bDisplayAdministrationFunctionality) {
            bDisplayAdministrationFunctionality = this.isMemberOfAccessRole(ACCESS_ROLE_ADMINISTRATOR);
        }
        if (!bDisplayAdministrationFunctionality) {
            bDisplayAdministrationFunctionality = this.isMemberOfAccessRole(ACCESS_ROLE_AE_ADMINISTRATOR);
        }
        if (!bDisplayAdministrationFunctionality) {
            bDisplayAdministrationFunctionality = this.isDevelopmentModeEnabled();
        }
        this.setHiddenProperty(PROP_DISPLAY_ADMIN_FUNCTIONALITY, bDisplayAdministrationFunctionality);
        return bDisplayAdministrationFunctionality;
    }

    public boolean isAllowedToRunAdministrationApp() throws VWException {
        if (this.getDisplayAdministrationFunctionality()) {
            return this.hasPrivileges(1);
        }
        return false;
    }

    public boolean getDisplayConfigurationFunctionality() throws VWException {
        Object value = this.getHiddenProperty(PROP_DISPLAY_CONFIG_FUNCTIONALITY);
        if (value != null && value instanceof Boolean) {
            return (Boolean)value;
        }
        boolean bDisplayConfigurationFunctionality = this.isIMSuiteWebApp();
        if (!bDisplayConfigurationFunctionality) {
            bDisplayConfigurationFunctionality = this.isMemberOfAccessRole(ACCESS_ROLE_CONFIGURATION);
        }
        if (!bDisplayConfigurationFunctionality) {
            bDisplayConfigurationFunctionality = this.isMemberOfAccessRole(ACCESS_ROLE_AE_ADMINISTRATOR);
        }
        if (!bDisplayConfigurationFunctionality) {
            bDisplayConfigurationFunctionality = this.isDevelopmentModeEnabled();
        }
        if (bDisplayConfigurationFunctionality) {
            bDisplayConfigurationFunctionality = this.hasPrivileges(2) || this.hasPrivileges(1);
        }
        this.setHiddenProperty(PROP_DISPLAY_CONFIG_FUNCTIONALITY, bDisplayConfigurationFunctionality);
        return bDisplayConfigurationFunctionality;
    }

    public boolean isAllowedToRunConfigurationApp() throws VWException {
        return this.getDisplayConfigurationFunctionality();
    }

    public ClassLoader getExternalClassLoader() {
        if (this.getParentApplet() != null) {
            return this.getParentApplet().getClass().getClassLoader();
        }
        return this.getParentContainer().getClass().getClassLoader();
    }

    public Enumeration getParameterNames() {
        try {
            if (this.m_properties == null) {
                return null;
            }
            return this.m_properties.propertyNames();
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return null;
        }
    }

    public JApplet getParentApplet() {
        return this.m_parentApplet;
    }

    public Container getParentContainer() {
        return this.m_parentContainer;
    }

    public Frame getParentFrame() {
        if (this.m_parentFrame == null) {
            this.m_parentFrame = VWModalDialog.getParentFrameUsingContainer(this.m_parentContainer);
        }
        return this.m_parentFrame;
    }

    public JRootPane getParentRootPane() {
        Container parentContainer = this.getParentContainer();
        if (parentContainer != null) {
            if (this.getParentContainer() instanceof JApplet) {
                return ((JApplet)this.getParentContainer()).getRootPane();
            }
            if (this.getParentContainer() instanceof JFrame) {
                return ((JFrame)this.getParentContainer()).getRootPane();
            }
        }
        return null;
    }

    public Container getParentContentPane() {
        Container parentContainer = this.getParentContainer();
        if (parentContainer != null) {
            if (this.getParentContainer() instanceof JApplet) {
                return ((JApplet)this.getParentContainer()).getContentPane();
            }
            if (this.getParentContainer() instanceof JFrame) {
                return ((JFrame)this.getParentContainer()).getContentPane();
            }
        }
        return null;
    }

    public String getProperty(String keyStr) {
        if (keyStr == null || this.m_properties == null) {
            return null;
        }
        return this.m_properties.getProperty(keyStr);
    }

    public String[] getPublishedStepPaletteNames() {
        return this.parseString(this.getProperty("step_palettes"));
    }

    public int getRequestedHeight() {
        return this.m_nHeight;
    }

    public int getRequestedWidth() {
        return this.m_nWidth;
    }

    public String[] getRouterNames() {
        return this.parseString(this.getProperty("routerNames"));
    }

    public String[] getRouterPorts() {
        return this.parseString(this.getProperty("routerPorts"));
    }

    public String[] getRouterServiceNames() {
        String[] routerServiceNames = this.parseString(this.getProperty("routerServiceNames"));
        if (routerServiceNames != null) {
            for (int i = 0; i < routerServiceNames.length; ++i) {
                routerServiceNames[i] = routerServiceNames[i].toLowerCase();
            }
        }
        return routerServiceNames;
    }

    public String[] getRouterIsolatedRegions() {
        return this.parseString(this.getProperty("routerIsolatedRegions"));
    }

    public String getSelectedRouterPath() {
        return this.m_selectedRouterPath;
    }

    public VWSession getSession() {
        return this.m_vwSession;
    }

    public void resetVWSession() {
        this.m_vwSession = null;
    }

    public boolean getShowParticipants() {
        Object value = this.getHiddenProperty(PROP_SHOW_PARTICIPANTS);
        if (value != null && value instanceof Boolean) {
            return (Boolean)value;
        }
        boolean bShowParticipants = true;
        String participantsValue = this.getProperty("participants");
        if (participantsValue != null) {
            bShowParticipants = VWStringUtils.compare(participantsValue, "1") == 0;
        }
        this.setHiddenProperty(PROP_SHOW_PARTICIPANTS, bShowParticipants);
        return bShowParticipants;
    }

    public String[] getSystemRoles() {
        return this.parseString(this.getProperty("systemRoles"));
    }

    public int getTrackerMode() {
        return this.m_trackerMode;
    }

    public boolean isCustomWebApp() {
        Object value = this.getHiddenProperty(PROP_IS_CUSTOM_WEB_APP);
        if (value != null && value instanceof Boolean) {
            return (Boolean)value;
        }
        boolean bIsCustomWebApp = false;
        try {
            String webApp = VWIDMBaseFactory.getWebApp();
            int nWebAppId = Integer.parseInt(webApp);
            if (nWebAppId != -1 && nWebAppId >= 100) {
                bIsCustomWebApp = true;
            }
            this.setHiddenProperty(PROP_IS_CUSTOM_WEB_APP, bIsCustomWebApp);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bIsCustomWebApp;
    }

    protected boolean isIMSuiteWebApp() {
        return this.isWebWorkFloWebApp() || this.isOpenClientWebApp();
    }

    protected boolean isOpenClientWebApp() {
        Object value = this.getHiddenProperty(PROP_IS_OPEN_CLIENT_APP);
        if (value != null && value instanceof Boolean) {
            return (Boolean)value;
        }
        boolean bIsOpenClientApp = false;
        String webApp = VWIDMBaseFactory.getWebApp();
        if (webApp != null && VWStringUtils.compare(webApp, "OPEN_CLIENT") == 0) {
            bIsOpenClientApp = true;
        }
        this.setHiddenProperty(PROP_IS_OPEN_CLIENT_APP, bIsOpenClientApp);
        return bIsOpenClientApp;
    }

    public boolean isWebWorkFloWebApp() {
        Object value = this.getHiddenProperty(PROP_IS_WEB_WORKFLO_APP);
        if (value != null && value instanceof Boolean) {
            return (Boolean)value;
        }
        boolean bIsWebWorkflowApp = false;
        String webApp = VWIDMBaseFactory.getWebApp();
        if (webApp != null && VWStringUtils.compare(webApp, "WEB_WORKFLO") == 0) {
            bIsWebWorkflowApp = true;
        }
        this.setHiddenProperty(PROP_IS_WEB_WORKFLO_APP, bIsWebWorkflowApp);
        return bIsWebWorkflowApp;
    }

    public boolean isWorkPlaceWebApp() {
        Object value = this.getHiddenProperty(PROP_IS_WORKPLACE_APP);
        if (value != null && value instanceof Boolean) {
            return (Boolean)value;
        }
        boolean bIsWorkplaceApp = false;
        String webApp = VWIDMBaseFactory.getWebApp();
        if (webApp != null && VWStringUtils.compare(webApp, "WORKPLACE") == 0) {
            bIsWorkplaceApp = true;
        }
        this.setHiddenProperty(PROP_IS_WORKPLACE_APP, bIsWorkplaceApp);
        return bIsWorkplaceApp;
    }

    public void updateDefaultWebApplication(VWSession vwSession) {
        try {
            if (this.isWorkPlaceWebApp()) {
                vwSession.setDefaultWebApplication(1);
            } else if (this.isOpenClientWebApp()) {
                vwSession.setDefaultWebApplication(3);
            } else if (this.isCustomWebApp()) {
                vwSession.setDefaultWebApplication(100);
            } else {
                vwSession.setDefaultWebApplication(2);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public boolean isP8WebApp(int nWebAppId) {
        return VWWebAppComboBox.isP8WebApp(nWebAppId);
    }

    public void logoff() {
        try {
            if (this.m_vwSession != null) {
                this.m_vwSession.logoff();
                this.m_vwSession = null;
            }
            if (this.m_logonDialog != null) {
                this.m_logonDialog.dispose();
                this.m_logonDialog = null;
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void setIDMInfo(String libraryName, String linkType, String docId) {
        this.setProperty("library", libraryName);
        this.setProperty("linkType", linkType);
        this.setProperty("docId", docId);
    }

    public void setLaunchInfo(String wfDocId, String attachDocId, String subject) {
        this.setProperty("workflowDefinitionDocID", wfDocId);
        this.setProperty("mainAttachmentDocID", attachDocId);
        this.setProperty("subject", subject);
    }

    public void setParentContainer(Container parentContainer) {
        this.m_parentContainer = parentContainer;
    }

    public void setProperty(String keyStr, String valueStr) {
        if (keyStr == null || keyStr.length() == 0) {
            return;
        }
        if (valueStr == null || valueStr.length() == 0) {
            this.m_properties.remove(keyStr);
            return;
        }
        if (this.m_properties != null) {
            this.m_properties.setProperty(keyStr, valueStr);
        }
    }

    public void setRequestedSize(int nWidth, int nHeight) {
        this.m_nWidth = nWidth;
        this.m_nHeight = nHeight;
    }

    public void setRuntimeInfo(String queueName, String wobNumber) {
        this.setProperty("queueName", queueName);
        this.setProperty("wobNumber", wobNumber);
    }

    public void setTrackerMode(int mode) {
        this.m_trackerMode = mode;
    }

    public boolean verifyLogon(String securityGroupName) {
        String[] groupNames = null;
        if (securityGroupName != null) {
            groupNames = new String[]{securityGroupName};
        }
        return this.verifyLogon(groupNames, false);
    }

    public boolean verifyLogon(String[] securityGroupNames, boolean bCheckAll) {
        try {
            if (this.m_vwSession == null) {
                this.checkTokenProperty();
                if (this.m_vwSession == null) {
                    return this.logon(securityGroupNames, true);
                }
            }
            if (this.m_logonDialog == null) {
                this.m_logonDialog = new VWLogonDialog(this.getParentFrame(), this);
            }
            return this.m_logonDialog.validateUser(securityGroupNames, this.isDevelopmentModeEnabled());
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return false;
        }
    }

    public boolean verifyLogonWithoutSessionManagement(String securityGroupName) {
        try {
            if (this.m_vwSession == null) {
                return this.logon(securityGroupName, false);
            }
            if (this.m_logonDialog == null) {
                this.m_logonDialog = new VWLogonDialog(this.getParentFrame(), this);
            }
            String[] groupNames = null;
            if (securityGroupName != null) {
                groupNames = new String[]{securityGroupName};
            }
            return this.m_logonDialog.isLogonOK(groupNames, false, this.isDevelopmentModeEnabled());
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return false;
        }
    }

    public String getSecurityGroupName() {
        if (this.m_logonDialog != null) {
            return this.m_logonDialog.getSecurityGroupName();
        }
        return null;
    }

    protected Object clone() {
        VWSessionInfo sessionInfo = new VWSessionInfo(this.m_parentContainer, this.m_parentApplet, this.m_vwSession);
        sessionInfo.m_logonDialog = null;
        sessionInfo.m_properties = (Properties)this.m_properties.clone();
        sessionInfo.m_trackerMode = this.m_trackerMode;
        sessionInfo.m_nWidth = this.m_nWidth;
        sessionInfo.m_nHeight = this.m_nHeight;
        if (this.m_selectedRouterPath != null && this.m_selectedRouterPath.length() > 0) {
            sessionInfo.m_selectedRouterPath = this.m_selectedRouterPath.trim();
        }
        if (this.m_hiddenProperties != null) {
            sessionInfo.m_hiddenProperties = (Hashtable)this.m_hiddenProperties.clone();
        }
        return sessionInfo;
    }

    private void initializeUsingArgs(VWCommandLineArgs args) {
        if (this.m_properties != null && args != null) {
            Enumeration paramNames = args.parameterNames();
            if (paramNames == null) {
                return;
            }
            while (paramNames.hasMoreElements()) {
                String name = (String)paramNames.nextElement();
                this.setProperty(name, args.getParameter(name));
            }
            this.setDefaultLocale();
            try {
                String webApp = this.getProperty("webApp");
                if (webApp != null && webApp.length() > 0) {
                    VWIDMBaseFactory.instance(args);
                }
            }
            catch (Exception ex) {
                VWDebug.logException(ex);
            }
        }
    }

    private void checkTokenProperty() {
        try {
            String token;
            if (this.m_vwSession == null && this.isIMSuiteWebApp() && (token = this.getProperty("token")) != null && token.length() > 0) {
                if (this.m_logonDialog == null) {
                    this.m_logonDialog = new VWLogonDialog(this.getParentFrame(), this);
                }
                if (this.m_logonDialog.logonWithToken(token)) {
                    this.m_vwSession = this.m_logonDialog.getVWSession();
                    this.displayLoggedOnUser();
                    this.m_selectedRouterPath = this.m_logonDialog.getSelectedRouterPath();
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void displayLoggedOnUser() {
        try {
            VWUserInfo userInfo;
            if (this.m_vwSession != null && (userInfo = this.m_vwSession.fetchCurrentUserInfo()) != null) {
                System.out.println("Logged on as: " + userInfo.getName());
                System.out.println("Using connection point: " + this.m_vwSession.getConnectionPointName() + " for " + this.m_vwSession.getServerName() + ":" + this.m_vwSession.getIsolatedRegion());
            }
        }
        catch (VWException ex) {
            VWDebug.logException(ex);
        }
    }

    private String getHostName(Applet applet) {
        int nIndex;
        String protocol;
        String hostName = null;
        StringTokenizer st = new StringTokenizer(applet.getDocumentBase().toString().toLowerCase(), "/");
        if (st.hasMoreTokens() && ((protocol = st.nextToken()).equals("http:") || protocol.equals("https:")) && st.hasMoreTokens() && (nIndex = (hostName = st.nextToken()).indexOf(":")) != -1) {
            hostName = hostName.substring(0, nIndex);
        }
        return hostName;
    }

    private boolean logon(String securityGroupName, boolean bSessionManagement) {
        String[] groupNames = new String[]{securityGroupName};
        return this.logon(groupNames, bSessionManagement);
    }

    private boolean logon(String[] securityGroupNames, boolean bSessionManagement) {
        try {
            if (this.m_logonDialog == null) {
                this.m_logonDialog = new VWLogonDialog(this.getParentFrame(), this);
            }
            if (this.m_logonDialog.isLogonOK(securityGroupNames, bSessionManagement, this.isDevelopmentModeEnabled())) {
                this.m_vwSession = this.m_logonDialog.getVWSession();
                this.displayLoggedOnUser();
                this.m_selectedRouterPath = this.m_logonDialog.getSelectedRouterPath();
            }
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this.getParentFrame(), ex.getMessage(), VWResource.s_error, 0);
            VWDebug.logException(ex);
            this.m_vwSession = null;
        }
        return this.m_vwSession != null;
    }

    private String[] parseString(String sourceStr) {
        Object[] stringArray = null;
        try {
            if (sourceStr != null && sourceStr.length() > 0 && sourceStr.compareTo("null") != 0) {
                int nIndex;
                Vector<String> items = new Vector<String>();
                while ((nIndex = sourceStr.indexOf(44)) != -1) {
                    items.addElement(sourceStr.substring(0, nIndex).trim());
                    sourceStr = sourceStr.substring(nIndex + 1);
                }
                if (sourceStr.length() > 0) {
                    items.addElement(sourceStr.trim());
                }
                if (!items.isEmpty()) {
                    stringArray = new String[items.size()];
                    items.copyInto(stringArray);
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return stringArray;
    }

    private Object getHiddenProperty(String key) {
        if (this.m_hiddenProperties != null && this.m_hiddenProperties.containsKey(key)) {
            return this.m_hiddenProperties.get(key);
        }
        return null;
    }

    private void setHiddenProperty(String key, Object value) {
        if (this.m_hiddenProperties == null) {
            this.m_hiddenProperties = new Hashtable();
        }
        this.m_hiddenProperties.put(key, value);
    }

    private void setDefaultLocale() {
        try {
            Locale browserLocale = this.getBrowserLocale();
            if (browserLocale != null) {
                Locale.setDefault(browserLocale);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private boolean isMemberOfAccessRole(String accessRoleName) {
        String[] systemRoles = this.getSystemRoles();
        if (systemRoles != null && systemRoles.length > 0) {
            for (int i = 0; i < systemRoles.length; ++i) {
                if (systemRoles[i] == null || VWStringUtils.compareIgnoreCase(systemRoles[i], accessRoleName) != 0) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isDevelopmentModeEnabled() {
        String stringValue = this.getProperty(DEVELOPMENT_MODE);
        if (stringValue != null) {
            return VWStringUtils.compare(stringValue, "1") == 0;
        }
        return false;
    }

    private boolean hasPrivileges(int nPrivilegeFlag) throws VWException {
        try {
            if (this.m_privilegesFlags == -1) {
                this.m_privilegesFlags = this.m_vwSession.fetchPrivileges();
            }
            return (this.m_privilegesFlags & nPrivilegeFlag) == nPrivilegeFlag;
        }
        catch (VWException ex) {
            VWDebug.logException(ex);
            VWMessageDialog.showOptionDialog(this.getParentFrame(), ex.getLocalizedMessage(), 1);
            throw ex;
        }
    }
}

